<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Jobs\NotifyViaMqtt;
use App\Models\Admin\Driver;
use App\Jobs\NotifyViaSocket;
use App\Models\Request\Request;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Models\Request\RequestMeta;
use App\Jobs\NoDriverFoundNotifyJob;
use App\Base\Constants\Masters\PushEnums;
use App\Jobs\Notifications\AndroidPushNotification;
use App\Transformers\Requests\TripRequestTransformer;
use App\Transformers\Requests\CronTripRequestTransformer;
use App\Models\Request\DriverRejectedRequest;
use Sk\Geohash\Geohash;
use Kreait\Firebase\Contract\Database;
use App\Base\Constants\Setting\Settings;
use App\Jobs\Notifications\SendPushNotification;
use Illuminate\Support\Facades\Log;
use App\Helpers\Rides\FetchDriversFromFirebaseHelpers;


class AssignDriversForScheduledRides extends Command
{
    use FetchDriversFromFirebaseHelpers;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'assign_drivers:for_schedule_rides';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Assign Drivers for schdeulesd rides';

    /**
     * Create a new command instance.
     *
     * @return void
     */

   protected  $database;

    public function __construct(Database $database)
    {
        parent::__construct();
        $this->database = $database;
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

       $ride_cancelation_time =Carbon::now()->subMinutes(10)->format('Y-m-d H:i:s');

       $uncompleted_requests = Request::where('trip_start_time', '<', $ride_cancelation_time)
           ->where('is_later', 1)
           ->where('is_completed', 0)
           ->where('is_cancelled', 0)
           ->where('is_driver_started', 0)
           ->get();

      if($uncompleted_requests) {  
       foreach ($uncompleted_requests as $uncompleted_request) 
       {
           $update_parms['is_cancelled'] = true;
           $update_parms['cancelled_at'] = date('Y-m-d H:i:s');
           $update_parms['cancel_method'] = 0;
           
           $uncompleted_request->update($update_parms);

           if($uncompleted_request->driver_id){
            Driver::where('id',$uncompleted_request->driver_id)->update(['available'=>true]);
        }
        
        
           $this->database->getReference('requests/'.$uncompleted_request->id)->update(['is_cancelled'=>true,'updated_at'=> Database::SERVER_TIMESTAMP]);
           $this->database->getReference('bid-meta/'.$uncompleted_request->id)->remove();
           $this->database->getReference('request-meta/'.$uncompleted_request->id)->remove();
               // dd($uncompleted_request);
        }
     }

    $requests = Request::where('is_later', 1)
                    ->whereNull('driver_id')
                    ->where('is_bid_ride',0)
                    ->where('is_completed', 0)->where('is_cancelled', 0)->where('is_driver_started', 0)->get();

        if ($requests->count()==0) {
            return $this->info('no-schedule-rides-found');
        }

        // dd(DB::getQueryLog());
        foreach ($requests as $key => $request) {
            // Trip times are stored in UTC for scheduled rides; compare in UTC to avoid timezone drift
            $tripStartUtc = Carbon::parse($request->trip_start_time, 'UTC');
            // Determine search window in MINUTES (no seconds conversion)
            // Determine dispatch window in minutes
            if (!empty($request->is_out_station)) {
                // For outstation scheduled rides, always use the configured window (default 30)
                $configured = (int) get_settings('minimum_time_for_search_drivers_for_schedule_ride');
                $findable_duration = $configured > 0 ? $configured : 30;
            } else if ($request->prefered_arriving_time) {
                // For non-outstation, honor preferred arriving time if provided (minutes)
                $findable_duration = (int) $request->prefered_arriving_time;
            } else {
                $configured = (int) get_settings('minimum_time_for_search_drivers_for_schedule_ride');
                $findable_duration = $configured > 0 ? $configured : 30; // default 30 minutes if unset
            }

            // Window starts exactly at trip_start_time - findable_duration (no extra buffer)
            $windowStartUtc = $tripStartUtc->copy()->subMinutes($findable_duration);
            $nowUtc = Carbon::now('UTC');

            // Only proceed if we're within the window [windowStart, tripStart]
            if (!$nowUtc->between($windowStartUtc, $tripStartUtc, true)) {
                continue; // don't break the loop; just skip this request for now
            }

            if ($nowUtc->greaterThan($tripStartUtc)) {
                // Past start time -> cancel as per existing behavior
                $this->cancelRequest($request);
            } else {
                // Within window before start -> begin driver search
                $request->update(['on_search' => true]);
                try {
                    $this->database->getReference('requests/'.$request->id)->update([
                        'on_search' => true,
                        'active' => 1,
                        'updated_at' => Database::SERVER_TIMESTAMP,
                    ]);
                } catch (\Exception $e) {
                    Log::error('[AssignDriversForScheduledRides] Failed to update firebase on_search: '.$e->getMessage());
                }
                $this->fetchDriversFromFirebase($request, $this->database);
            }

        }

        $this->info('success');
    }

    public function cancelRequest($request)
    {
        // Log::info("-------cancel schduled ride request---------");
        // Log::info($request);

        $this->database->getReference('requests/'.$request->id)->update(['is_cancel' => 1]);

        $no_driver_request_ids = [];
        $no_driver_request_ids[0] = $request->id;
        dispatch(new NoDriverFoundNotifyJob($no_driver_request_ids, $this->database));


    }

}
