<?php

namespace App\Helpers\Rides;

use Kreait\Firebase\Contract\Database;
use Sk\Geohash\Geohash;
use Carbon\Carbon;
use App\Models\Request\RequestMeta;
use Illuminate\Support\Facades\DB;
use App\Models\Request\Request;
use Illuminate\Support\Facades\Log;
use App\Base\Constants\Setting\Settings;
use App\Models\Admin\Driver;
use App\Jobs\Notifications\SendPushNotification;
use App\Models\Request\DriverRejectedRequest;
use App\Jobs\NoDriverFoundNotifyJob;
use App\Models\Admin\ZoneSurgePrice;
use App\Models\Request\RequestCancellationFee;
use App\Models\Admin\PromoUser;
use App\Helpers\Rides\CalculatAdminCommissionAndTaxHelper;

trait RidePriceCalculationHelpers
{
    use CalculatAdminCommissionAndTaxHelper;



    /**
     * Calculate Ride fare
     * pick lat,pick lng, drop lat, drop lng should be double
     * total_distance can be double
     * duration should be in integer and in mins
     * 
     */
    //
    protected function calculateBillForARide($pick_lat,$pick_lng,$drop_lat,$drop_lng,$total_distance, $duration, $zone_type, $type_prices, $coupon_detail,$timezone,$user_id,$waiting_time,$request_detail,$driver,$airport_surge_fee)

    {
        // Resolve effective trip flags from request payload or persisted request_detail
        $effective_is_out_station = request()->has('is_out_station')
            ? (bool) request()->is_out_station
            : (bool) ($request_detail->is_out_station ?? false);

        $effective_is_round_trip = request()->has('is_round_trip')
            ? (bool) request()->is_round_trip
            : (bool) ($request_detail->is_round_trip ?? false);

        // Outstation round trip extra km logic
        // Rule: no extra-km charge below 100km; for >=100km round trips, charge extra km using round_out_extr_km_t1000
        $extra_round_trip_km_price = 0;
        if (
            $effective_is_out_station &&
            $effective_is_round_trip &&
            $total_distance >= 100 && isset($type_prices->round_out_extr_km_t1000)
        ) {
            $expected_round_trip_distance = $total_distance;
            if (isset($request_detail->completed_distance) && $request_detail->completed_distance > $expected_round_trip_distance) {
                $extra_km = $request_detail->completed_distance - $expected_round_trip_distance;
                $extra_round_trip_km_price = $extra_km * $type_prices->round_out_extr_km_t1000;
            }
        }

        $is_round = (integer)get_settings('can_round_the_bill_values');
        
        /**
         * Distance price calculation starts here
         * 
         * */

        // Pricing Parameters
        $price_per_distance = $type_prices->price_per_distance;

        // $ride_setting_distance = (integer)get_settings('minimum_trip_distane');

        // $dropoff_distance_in_meters = request()->distance;

        // $distance = $dropoff_distance_in_meters / 1000;
        
        if($effective_is_out_station){
            // Outstation trip: below 100km, no extra-km concept (use slab base only)
            // For >=100km, set indicative per-km rate based on trip type
            if ($total_distance >= 100) {
                if ($effective_is_round_trip && isset($type_prices->round_out_extr_km_t1000)) {
                    $price_per_distance = $type_prices->round_out_extr_km_t1000;
                } elseif (isset($type_prices->one_out_extr_km_t1000)) {
                    $price_per_distance = $type_prices->one_out_extr_km_t1000;
                } else {
                    $price_per_distance = $type_prices->outstation_price_per_distance;
                }
            } else {
                $price_per_distance = $type_prices->outstation_price_per_distance;
            }
        }
        if($driver && $driver->price_per_distance!=null)
        {
            // Log::info("Driver True");
            // Apply driver custom per-km only for local rides; don't override outstation rates
            if (!$effective_is_out_station) {
                $price_per_distance = $driver->price_per_distance;
            }

            // Log::info($price_per_distance);


        }

        $base_distance = (double) $type_prices->base_distance;

        if(request()->has('is_out_station') && request()->is_out_station){
            
            $base_distance = (double) $type_prices->outstation_base_distance;

        }
        $calculatable_distance = ($total_distance - $base_distance);

        if($calculatable_distance < 0 ){

            $calculatable_distance = 0;
        }


        // Calculate Surge price 
        $current_time = Carbon::now()->setTimezone($timezone);
        $day = $current_time->dayName;
        $current_time = $current_time->toTimeString();


        // Set price surge
        $zone_surge_price = ZoneSurgePrice::where('zone_type_id',$zone_type->id)->where('day',$day)->whereTime('start_time','<=',$current_time)->whereTime('end_time','>=',$current_time)->first();

        $surge_percent = 0;

        // if($zone_surge_price){
            
        //     $surge_percent += $zone_surge_price->value;


        // }

        // Peak Zone surge
        $peak_zone = find_peak_zone(request()->pick_lat,request()->pick_lng);

        if($peak_zone){
            
            $surge_percent += $peak_zone->distance_price_percentage;

        }

        // Only add surge to price_per_distance for outstation rides
        // For local rides, surge will be added to base_price below
    if ($effective_is_out_station) {
            $surge_price_additional_cost = ($price_per_distance * ($surge_percent / 100));
            $price_per_distance += $surge_price_additional_cost;
        }

         // Base price
         
        // $base_price = $type_prices->base_price;

// STEP 1: Determine if outstation ride
$request_is_out_station = $effective_is_out_station;

$is_local_ride = (!$request_is_out_station) || ($airport_surge_fee > 0);

// Force to local ride if ≤ 12 km
// if ($total_distance <= 12) {
//     $request_is_out_station = false;
// }

    if ($request_is_out_station) {
        $outstation_base_price_json = is_array($type_prices->outstation_base_price)
            ? $type_prices->outstation_base_price
            : json_decode($type_prices->outstation_base_price, true) ?? [];

        $rounded_distance = (int) ceil($total_distance);
        $distance_price = 0;
        $calculatable_distance = 0;

        // New rule: For outstation trips with distance > 175km, do NOT use DB base slabs.
        // Entire fare is computed as distance * per-km rate depending on trip type.
        if ($rounded_distance > 175) {
            if ($effective_is_round_trip) {
                $rate = $type_prices->round_out_extr_km_t1000 ?? $type_prices->outstation_price_per_distance;
            } else {
                $rate = $type_prices->one_out_extr_km_t1000 ?? $type_prices->outstation_price_per_distance;
            }

            // Apply surge for outstation rides if any (consistent with existing behavior)
            if (isset($surge_percent) && $surge_percent > 0) {
                $rate += ($rate * ($surge_percent / 100));
            }

            $base_price = $rounded_distance * $rate; // e.g., 180km * 18 = 3240
            // If round trip and >175km, double the base price as per requirement
            if ($effective_is_round_trip) {
                $base_price *= 2;
            }
            $base_distance = $rounded_distance;
            $distance_price = 0;
            $calculatable_distance = 0;
            $price_per_distance = $rate; // reflect effective per-km used

    } elseif ($total_distance >= 100 && $total_distance < 175) {
            // 100 – 174.99 KM
            $base_price = $outstation_base_price_json[100] ?? $type_prices->base_price;
            $base_distance = 100;

            $calculatable_distance = max(0, $total_distance - 100);
            // For round trips in this band, additional distance km should be doubled
            if ($effective_is_round_trip) {
                $calculatable_distance *= 2;
            }
            if ($calculatable_distance > 0) {
                // Use correct per-km based on trip type within this band
                if ($effective_is_round_trip && isset($type_prices->round_out_extr_km_t1000)) {
                    $distance_price = $calculatable_distance * $type_prices->round_out_extr_km_t1000;
                } elseif (isset($type_prices->one_out_extr_km_t1000)) {
                    $distance_price = $calculatable_distance * $type_prices->one_out_extr_km_t1000;
                } else {
                    $distance_price = $calculatable_distance * $type_prices->outstation_price_per_distance;
                }
            } else {
                $distance_price = 0;
            }

        } elseif ($rounded_distance > 12 && $rounded_distance <= 99) {
            // 13 – 99.99 KM: Use exact fare from slab, no additional fare
            $base_price = $outstation_base_price_json[$rounded_distance] ?? $type_prices->base_price;
            $base_distance = $rounded_distance;
            $distance_price = 0;
            $calculatable_distance = 0;
            // No extra-km concept below 100km; expose outstation base per-km for display only
            $price_per_distance = $type_prices->outstation_price_per_distance;
        } else {
            // 12 KM or below: Use slab logic as in local rides
            if ($total_distance <= 6.9) {
                $base_price = $type_prices->base_price;
                $base_distance = $type_prices->base_distance;
            } elseif ($total_distance <= 9.9) {
                $base_price = $type_prices->base7_price;
                $base_distance = $type_prices->base7_distance;
            } elseif ($total_distance <= 12) {
                $base_price = $type_prices->base10_price;
                $base_distance = $type_prices->base10_distance;
            } else {
                // fallback
                $base_price = $type_prices->base_price;
                $base_distance = $type_prices->base_distance;
            }
            $calculatable_distance = $total_distance - $base_distance;
            if ($calculatable_distance < 0) $calculatable_distance = 0;
            $price_per_distance = $type_prices->price_per_distance; // Use local rate for ≤12km
            $distance_price = $calculatable_distance * $price_per_distance;
        }

} else {
    // ===== LOCAL RIDE =====
    if ($total_distance <= 6.9) {
        $base_price = $type_prices->base_price;
        $base_distance = $type_prices->base_distance;
    } elseif ($total_distance <= 9.9) {
        $base_price = $type_prices->base7_price;
        $base_distance = $type_prices->base7_distance;
    } elseif ($total_distance <= 12) {
        $base_price = $type_prices->base10_price;
        $base_distance = $type_prices->base10_distance;
    } else {
        // fallback
        $base_price = $type_prices->base_price;
        $base_distance = $type_prices->base_distance;
    }

    // Add zone_surge_price only for local rides
    if ($zone_surge_price) {
        $base_price += $zone_surge_price->value;
    }

    $calculatable_distance = $total_distance - $base_distance;
    if ($calculatable_distance < 0) $calculatable_distance = 0;

    $distance_price = $calculatable_distance * $price_per_distance;
    $distance_price = $is_round ? ceil($distance_price) : round($distance_price, 2);
}
         // Time price
        // Use correct price per time for outstation or local
        if ($request_is_out_station) {
            $price_per_time = $type_prices->outstation_price_per_time;
        } else {
            $price_per_time = $type_prices->price_per_time;
        }

        if ($request_is_out_station) {
            // Outstation ride: apply outstation time price ONLY if trip is completed AND actual duration > originally booked duration
            if (
                isset($request_detail->trip_status) && $request_detail->trip_status === 'Completed' &&
                isset($request_detail->booking_time) && $duration > $request_detail->booking_time
            ) {
                    $extra_time = $duration - $request_detail->booking_time;
                    $time_price = $extra_time * $type_prices->outstation_price_per_time;
            } else {
                // Do not add outstation time price during booking, if not completed, or if actual duration <= booked duration
                $time_price = 0;
                    $extra_time = 0;
            }
        } else {
            // Normal ride (≤12km): no time charge
            $time_price = 0;
                $extra_time = 0;
        }
        //  $time_price = $duration * $type_prices->price_per_time;

         $time_price = round($time_price,2);

        // Only recalculate distance_price for LOCAL rides
if (!$request_is_out_station) {
    $distance_price = $calculatable_distance * $price_per_distance;
    $distance_price = $is_round ? ceil($distance_price) : round($distance_price, 2);
}

         // Waiting charge
        $waiting_charge = $waiting_time * $type_prices->waiting_charge;

        $waiting_charge = round($waiting_charge,2);

        $sub_total = $base_price + $time_price + $distance_price + $waiting_charge + $airport_surge_fee;
    // Add extra round trip km price if any
    $sub_total += $extra_round_trip_km_price;

        $sub_total = round($sub_total,2);

        if($is_round){
            
        // Time price
         $time_price = ceil($time_price);

        // Distance Price

        $distance_price = ceil($distance_price);

         // Waiting charge
        $waiting_charge = ceil($waiting_charge);


        $sub_total = ceil($sub_total);

        }

       
        /**
         * Apply Coupon
         * Default: coupons apply only to normal (local) rides. If coupon has
         * `apply_for_outstation` truthy, allow on outstation rides as well.
         */

        $discount_amount = 0;
        $coupon_applied_sub_total = 0;
        $calculated_sub_total_for_coupon = $sub_total;
        $promo_applied = false;

        if ($coupon_detail) {
            $coupon_applied_sub_total = $sub_total;

            // Determine if coupon explicitly allows outstation rides
            $coupon_allows_outstation = false;
            if (is_object($coupon_detail) || is_array($coupon_detail)) {
                $coupon_allows_outstation = isset($coupon_detail->apply_for_outstation) && $coupon_detail->apply_for_outstation
                    || (is_array($coupon_detail) && isset($coupon_detail['apply_for_outstation']) && $coupon_detail['apply_for_outstation']);
            }

            // If this is an outstation ride and the coupon doesn't allow outstation, skip applying
            if ($request_is_out_station && !$coupon_allows_outstation) {
                if ($request_detail) {
                    PromoUser::where('request_id', $request_detail->id)->delete();
                }
            } else {
                // Apply coupon normally (minimum/maximum checks)
                if ($coupon_detail->minimum_trip_amount <= $sub_total) {
                    $discount_amount = $sub_total * ($coupon_detail->discount_percent/100);
                    if ($coupon_detail->maximum_discount_amount>0 && $discount_amount > $coupon_detail->maximum_discount_amount) {
                        $discount_amount = $coupon_detail->maximum_discount_amount;
                    }

                    $coupon_applied_sub_total = $sub_total - $discount_amount;

                    $coupon_applied_sub_total = round($coupon_applied_sub_total,2);

                    if($is_round){
                        $coupon_applied_sub_total = ceil($coupon_applied_sub_total);
                    }

                    $calculated_sub_total_for_coupon = $coupon_applied_sub_total;
                    $promo_applied= true;
                } else {
                    if($request_detail){
                        PromoUser::where('request_id', $request_detail->id)->delete();
                    }
                }
            }
        }


        // Apply coupon ends here

        if($request_detail){

        // Calculate Ride Cancellation Fee
        $cancellation_fee = RequestCancellationFee::where('user_id',$request_detail->user_id)->where('is_paid',0)->sum('cancellation_fee');

        $cancellation_fee = round($cancellation_fee,2);

        if($is_round){
            $cancellation_fee = ceil($cancellation_fee);
        }
        $sub_total += $cancellation_fee;

        if($cancellation_fee >0){

            RequestCancellationFee::where('user_id',$request_detail->user_id)->update([
                'is_paid'=>1,
                'paid_request_id'=>$request_detail->id]);

        }

         if($request_detail->is_bid_ride || $request_detail->is_trip_meter){
                
                $sub_total=$request_detail->accepted_ride_fare;
            }


        }

        
        $discount_admin_commision_and_tax = $this->calculateAdminCommissionAndTax($calculated_sub_total_for_coupon,$zone_type,$request_detail);

        $discount_tax_amount = 0;
        // if (request()->has('is_out_station') && request()->is_out_station) {
        //     if (request()->has('is_round_trip') && request()->is_round_trip) {
        //         if ($total_distance > 175) {
        //             $discount_tax_amount = $zone_type->service_tax;
        //         }
        //     } else {
        //         if ($total_distance > 350) {
        //             $discount_tax_amount = $zone_type->service_tax;
        //         }
        //     }
        // }
        $discount_admin_commision = $discount_admin_commision_and_tax['admin_commision'];

        $admin_commision_and_tax = $this->calculateAdminCommissionAndTax($sub_total,$zone_type,$request_detail);
        $admin_commision = $admin_commision_and_tax['admin_commision'];
        $tax_amount = 0;
        $tax_percent = 0;
        
    // Service tax uses a fixed value (not percentage) and is applied for outstation rides
        if ($effective_is_out_station) {
            if ($effective_is_round_trip) {
        // Round trip: apply service tax if distance > 175km
        if ($total_distance > 175) {
                    // Calculate number of calendar days between start and end in ride's timezone, using date-only to avoid TZ drift
                    $rideTz = $timezone ?: config('app.timezone', 'UTC');

                    $haveActuals = isset($request_detail->trip_start_time) && isset($request_detail->completed_at);
                    if ($haveActuals) {
                        $start = \Carbon\Carbon::parse($request_detail->trip_start_time);
                        $end = \Carbon\Carbon::parse($request_detail->completed_at);
                    } else {
                        // ETA path: try to use request-provided pickup/return times, else derive using duration
                        if (request()->has('pickup_time')) {
                            $start = \Carbon\Carbon::parse(request()->pickup_time);
                        } elseif (request()->has('trip_start_time')) {
                            $start = \Carbon\Carbon::parse(request()->trip_start_time);
                        } else {
                            $start = \Carbon\Carbon::now($rideTz);
                        }

                        if (request()->has('return_time')) {
                            $end = \Carbon\Carbon::parse(request()->return_time);
                        } elseif (request()->has('expected_end_time')) {
                            $end = \Carbon\Carbon::parse(request()->expected_end_time);
                        } else {
                            $etaMinutes = is_numeric($duration) ? (int) ceil($duration) : 0;
                            $end = (clone $start)->addMinutes(max($etaMinutes, 0));
                        }
                    }

                    // Normalize to ride timezone and compute days based on calendar dates
                    $startLocal = (clone $start)->setTimezone($rideTz);
                    $endLocal = (clone $end)->setTimezone($rideTz);
                    $startDay = (clone $startLocal)->startOfDay();
                    $endDay = (clone $endLocal)->startOfDay();
                    $diffDays = $startDay->diffInDays($endDay);
                    if ($diffDays === 0) {
                        $days = 1; // same calendar day
                    } else if ($diffDays === 1) {
                        $days = 2; // next day => double
                    } else {
                        $days = $diffDays + 1; // inclusive for multi-day trips
                    }

                    $tax_amount = $zone_type->service_tax * $days;
                }
            } else {
                // One-way: apply service tax if distance > 175km
                if ($total_distance > 175) {
                    $tax_amount = $zone_type->service_tax;
                }
            }
        }
        // Admin commision with tax amount
        $admin_commision_with_tax = $tax_amount + $admin_commision;

        $discounted_total_price = $coupon_applied_sub_total + $discount_tax_amount + $discount_admin_commision;
        $discounted_total_price = round($discounted_total_price,2);
        if($is_round){
            $discounted_total_price = ceil($discounted_total_price);
        }
        
        // Driver.0 Commissions Starts Here

        // Always set commission variables before use
        if($driver && $driver->owner_id != NULL){
            $admin_commission_type_for_driver = $zone_type->admin_commission_type_for_owner ?? 0;
            $service_fee_for_driver = $zone_type->admin_commission_for_owner ?? 0;
        }else {
            $admin_commission_type_for_driver = $zone_type->admin_commission_type_from_driver ?? 0;
            $service_fee_for_driver = $zone_type->admin_commission_from_driver ?? 0;
        }

        // Airport trip commission logic
        if ($airport_surge_fee > 0) {
            // For airport trips, set driver_commision to airport_surge_fee
            $driver_commision = $airport_surge_fee;
            if ($admin_commission_type_for_driver == 1) {
                $admin_commission_from_driver = ($airport_surge_fee * ($service_fee_for_driver / 100));
            } else {
                $admin_commission_from_driver = $service_fee_for_driver;
            }
            $driver_commision -= $admin_commission_from_driver;
        } else {
            // Normal commission logic
            $driver_commision = $sub_total;
            $sub_total = $admin_commision_and_tax['sub_total'];
            if($admin_commission_type_for_driver==1){
                $admin_commission_from_driver = ($driver_commision * ($service_fee_for_driver / 100));
            }else{
                $admin_commission_from_driver = $service_fee_for_driver;
            }
            if($request_detail?->driverDetail?->is_subscribed && get_settings('driver_register_module') !== 'commission'){
                $admin_commission_from_driver = 0;
            }
            if(isset($cancellation_fee) && $cancellation_fee > 0){
                $admin_commission_from_driver += $cancellation_fee;
            }
            $driver_commision -= $admin_commission_from_driver;
            if($request_detail && $request_detail->is_bid_ride){
                $driver_commision -= $admin_commision_with_tax;
            }
        }
        // Driver Commissions Ends Here

        // Total Amount
        $total_amount = $sub_total + $admin_commision_with_tax;

        
        if ($request_detail && $request_detail->additional_charges_amount > 0){
            $total_amount += $request_detail->additional_charges_amount;
        }


        if($is_round==0){
            $total_amount = round($total_amount,2);

        }
        $admin_commision_with_tax += $admin_commission_from_driver;

        $pickup_duration = 0;
        $dropoff_duration = $duration;
        $wait_duration = 0;
        $duration = $pickup_duration + $dropoff_duration + $wait_duration;
        $price_per_distance = round($price_per_distance,2);
        if($is_round){

            $price_per_distance = ceil($price_per_distance);
        }


        if($request_detail){
        

    $result = [
        'base_price'=>$base_price,
        'base_distance'=>$base_distance ?? 0,
        'price_per_distance'=>$price_per_distance,
        'distance_price'=>$distance_price,
        'price_per_time'=>$price_per_time,
        'time_price'=>$time_price,
        'extra_time'=>$extra_time,
        'promo_discount'=>$discount_amount,
        'waiting_charge'=>$waiting_charge,
        'service_tax'=>$tax_amount,
        'service_tax_percentage'=>$tax_percent,
        'admin_commision'=>$admin_commision,
        'admin_commision_with_tax'=>$admin_commision_with_tax,
        'driver_commision'=>$driver_commision,
        'admin_commission_from_driver'=>$admin_commission_from_driver,
        'total_amount'=> $total_amount,
        'total_distance'=>$total_distance,
        'total_time'=>$duration,
        'airport_surge_fee'=>$airport_surge_fee,
        'cancellation_fee'=>$cancellation_fee,
    ];

    if($discount_amount>0){
        $result['total_amount'] = $discounted_total_price;
        $result['admin_commision'] = $discount_admin_commision;
        $result['service_tax'] = $discount_tax_amount;
        $result['admin_commision_with_tax'] = ($discount_admin_commision + $discount_tax_amount + $admin_commission_from_driver);
    }

    // Debug log for promo_discount and coupon_detail
    // \Log::info('[RidePriceCalculationHelpers] Returning bill calculation', [
    //     'discount_amount' => $discount_amount,
    //     'promo_discount' => $result['promo_discount'] ?? null,
    //     'coupon_detail' => $coupon_detail,
    //     'total_amount' => $result['total_amount'] ?? null,
    // ]);

    return $result;


        }

    // If this is an airport drop, return only airport_surge_fee as the fare, but allow promo/discount
    if ($airport_surge_fee > 0) {
        $discount_amount = 0;
        $discounted_total = $airport_surge_fee;
        if ($coupon_detail) {
            if ($coupon_detail->minimum_trip_amount <= $airport_surge_fee) {
                $discount_amount = $airport_surge_fee * ($coupon_detail->discount_percent/100);
                if ($coupon_detail->maximum_discount_amount>0 && $discount_amount > $coupon_detail->maximum_discount_amount) {
                    $discount_amount = $coupon_detail->maximum_discount_amount;
                }
                $discounted_total = $airport_surge_fee - $discount_amount;
            }
        }
        return (object)[
            'base_price' => $airport_surge_fee,
            // Set base_distance to the actual trip distance for airport trips
            'base_distance' => $total_distance,
            'price_per_distance' => 0,
            'distance_price' => 0,
            'price_per_time' => 0,
            'time_price' => 0,
            'promo_discount' => $discount_amount,
            'discount_amount' => $discount_amount,
            'waiting_charge' => 0,
            'service_tax'=>0,
            'service_tax_percentage'=>0,
            'admin_commision'=>$admin_commision,
            'admin_commision_with_tax'=>$admin_commision_with_tax,
            'driver_commision'=>$driver_commision,
            'admin_commission_from_driver'=>$admin_commission_from_driver,
            'total_amount' => $discounted_total,
            'total_distance' => 0,
            'total_time' => 0,
            'airport_surge_fee' => $airport_surge_fee,
            'cancellation_fee' => 0,
            // Add all properties accessed in EtaTransformer.php:
            'distance' => 0,
            'duration' => 0,
            'base_distance' => 0,
            'calculated_distance' => 0,
            'subtotal_price' => $airport_surge_fee,
            'tax_amount' => 0,
            'without_discount_admin_commision' => 0,
            'discount_admin_commision' => 0,
            'tax_percent' => 0,
            'total_price' => $discounted_total,
            'discounted_total_price' => $discounted_total,
            'discount_total_tax_amount' => 0,
        ];
    }

        // return calculated params for eta
        return (object)[
                'distance' => $total_distance,
                'base_distance' => $base_distance,
                'base_price' => $base_price,
                'price_per_distance' => $price_per_distance,
                'price_per_time' => $price_per_time,
                'distance_price' => $distance_price,
                'time_price' => $time_price,
                'subtotal_price' => $sub_total,
                'calculated_distance' => number_format($calculatable_distance,2),
                'tax_percent' => $tax_percent,
                'tax_amount' => $tax_amount,
                'discount_total_tax_amount'=>$discount_tax_amount,
                'without_discount_admin_commision'=>$admin_commision,
                'discount_admin_commision'=>$discount_admin_commision,
                'total_price' => $total_amount,
                'discounted_total_price'=>$discounted_total_price,
                'discount_amount'=>$discount_amount,
                'pickup_duration' => $pickup_duration,
                'dropoff_duration' => $dropoff_duration,
                'wait_duration' =>$wait_duration,
                'duration' => $duration,
                'airport_surge_fee'=>$airport_surge_fee
            ];




    }

    protected function calculateRentalRideFares($zone_type_price, $distance, $duration, $waiting_time, $coupon_detail,$request_detail,$airport_surge_fee){

        // Distance Price
        $calculatable_distance = $distance - $zone_type_price->free_distance;
        $calculatable_distance = $calculatable_distance<0?0:$calculatable_distance;

        $price_per_distance = $zone_type_price->distance_price_per_km;

        // Validate if the current time in surge timings

        $timezone = $request_detail->serviceLocationDetail->timezone;

        $current_time = Carbon::now()->setTimezone($timezone);
        
        $day = $current_time->dayName;
        $current_time = $current_time->toTimeString();

        $zone_surge_price = $request_detail->zoneType->zoneSurge()->where('day',$day)->whereTime('start_time','<=',$current_time)->whereTime('end_time','>=',$current_time)->first();

        if($zone_surge_price){

            $surge_percent = $zone_surge_price->value;

            $surge_price_additional_cost = ($price_per_distance * ($surge_percent / 100));

            $price_per_distance += $surge_price_additional_cost;

            $request_detail->is_surge_applied = true;

            $request_detail->save();

        }

        $distance_price = $calculatable_distance * $price_per_distance;
        // Time Price
        $ride_duration = $duration > $zone_type_price->free_min ? $duration-$zone_type_price->free_min: 0; 
        $time_price = ($ride_duration) * $zone_type_price->time_price_per_min;
        // Waiting charge
        $waiting_charge = $waiting_time * $zone_type_price->waiting_charge;
        // Base Price
        $base_price = $zone_type_price->base_price;

        // Sub Total

        if($request_detail->zoneType->vehicleType->is_support_multiple_seat_price && $request_detail->passenger_count > 0){

            if($request_detail->passenger_count ==1){
                $seat_discount = $request_detail->zoneType->vehicleType->one_seat_price_discount;
            }
            if($request_detail->passenger_count ==2){
                $seat_discount = $request_detail->zoneType->vehicleType->two_seat_price_discount;
            }
            if($request_detail->passenger_count ==3){
                $seat_discount = $request_detail->zoneType->vehicleType->three_seat_price_discount;
            }
            if($request_detail->passenger_count ==4){
                $seat_discount = $request_detail->zoneType->vehicleType->four_seat_price_discount;
            }

            $base_price -= ($base_price * ($seat_discount / 100));

            $distance_price -=  ($distance_price * ($seat_discount / 100));

            $time_price -=  ($time_price * ($seat_discount / 100));

            $airport_surge_fee -= ($airport_surge_fee * ($seat_discount / 100));

        }

        $sub_total = $base_price+$distance_price+$time_price+$waiting_charge + $airport_surge_fee;


        $discount_amount = 0;

         if ($coupon_detail) {
            if ($coupon_detail->minimum_trip_amount < $sub_total) {

                $discount_amount = $sub_total * ($coupon_detail->discount_percent/100);
                if ($discount_amount > $coupon_detail->maximum_discount_amount) {
                    $discount_amount = $coupon_detail->maximum_discount_amount;
                }

                $sub_total = $sub_total - $discount_amount;
            }
        }
        $zone_type = $request_detail->zoneType;

        // Service tax only if distance > 350km
        $tax_amount = 0;
        $tax_percent = 0;
        if ($distance > 350) {
            $tax_amount = $zone_type_price->zoneType->service_tax;
        }

        // Get Admin Commision
        $admin_commision_type = $zone_type_price->zoneType->admin_commision_type;
        $service_fee = $zone_type_price->zoneType->admin_commision;

        $driver = auth()->user()->driver;



        if($driver && $driver->owner_id != NULL){

            $admin_commission_type_for_driver = $zone_type->admin_commission_type_for_owner ?? 0;
            $service_fee_for_driver = $zone_type->admin_commission_for_owner ?? 0;
        }else {
            $admin_commission_type_for_driver = $zone_type->admin_commission_type_from_driver ?? 0;
            $service_fee_for_driver = $zone_type->admin_commission_from_driver ?? 0;
        }
        
        if($admin_commision_type==1){

        $admin_commision = ($sub_total * ($service_fee / 100));

        }else{

            $admin_commision = $service_fee;

        }
        // Admin commision with tax amount
        $admin_commision_with_tax = $tax_amount + $admin_commision;
        $driver_commision = $sub_total+$discount_amount;
        // Driver Commission
        if($coupon_detail && $coupon_detail->deduct_from==2){
            $driver_commision = $sub_total;
        }

        $admin_commission_from_driver = 0;
        if($admin_commission_type_for_driver==1){

        $admin_commission_from_driver = ($driver_commision * ($service_fee_for_driver / 100));

        }else{

            $admin_commission_from_driver = $service_fee_for_driver;

        }
        $driver_commision -= $admin_commission_from_driver;

        // Total Amount
        $total_amount = $sub_total + $admin_commision_with_tax;
        $admin_commision_with_tax += $admin_commission_from_driver;

        return $result = [
        'base_price'=>$base_price,
        'base_distance'=>$zone_type_price->free_distance,
        'price_per_distance'=>$zone_type_price->distance_price_per_km,
        'distance_price'=>$distance_price,
        'price_per_time'=>$zone_type_price->time_price_per_min,
        'time_price'=>$time_price,
        'promo_discount'=>$discount_amount,
        'waiting_charge'=>$waiting_charge,
        'service_tax'=>$tax_amount,
        'service_tax_percentage'=>$tax_percent,
        'admin_commision'=>$admin_commision,
        'admin_commision_with_tax'=>$admin_commision_with_tax,
        'admin_commission_from_driver'=>$admin_commission_from_driver,
        'driver_commision'=>$driver_commision,
        'total_amount'=>$total_amount,
        'total_distance'=>$distance,
        'total_time'=>$duration,
        'airport_surge_fee'=>$airport_surge_fee
        ];
    }

    /**
     * Public test helper used by unit tests to check coupon applicability.
     */
    public function couponApplicableForTest($request_detail, $airport_surge_fee = 0, $override = null)
    {
        $effective_is_out_station = request()->has('is_out_station')
            ? (bool) request()->is_out_station
            : (bool) ($request_detail->is_out_station ?? false);

        if ($override === true) {
            return true;
        }

        if ($effective_is_out_station && ($airport_surge_fee == 0)) {
            return false;
        }

        return true;
    }

}
