<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddZoneSurgePriceToRequestBillsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('request_bills')) {
            if (!Schema::hasColumn('request_bills', 'zone_surge_price')) {
                Schema::table('request_bills', function (Blueprint $table) {
                    $table->decimal('zone_surge_price', 10, 2)->default(0)->after('airport_surge_fee');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('request_bills')) {
            if (Schema::hasColumn('request_bills', 'zone_surge_price')) {
                Schema::table('request_bills', function (Blueprint $table) {
                    $table->dropColumn('zone_surge_price');
                });
            }
        }
    }
}
